/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator.multichunk;

import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.module.config.type.ClusterSizeConfig;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.base.world.generator.multichunk.ClusterShape;
import vazkii.quark.base.world.generator.multichunk.MultiChunkFeatureGenerator;

public abstract class ClusterBasedGenerator
extends MultiChunkFeatureGenerator {
    public final ClusterShape.Provider shapeProvider;

    public ClusterBasedGenerator(DimensionConfig dimConfig, ClusterSizeConfig sizeConfig, long seedXor) {
        this(dimConfig, Generator.NO_COND, sizeConfig, seedXor);
    }

    public ClusterBasedGenerator(DimensionConfig dimConfig, BooleanSupplier condition, ClusterSizeConfig sizeConfig, long seedXor) {
        super(dimConfig, condition, seedXor);
        this.shapeProvider = new ClusterShape.Provider(sizeConfig, seedXor);
    }

    @Override
    public int getFeatureRadius() {
        return this.shapeProvider.getRadius();
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        ClusterShape shape = this.shapeProvider.around(src);
        IGenerationContext context = this.createContext(src, generator, random, chunkCorner, world);
        this.forEachChunkBlock(chunkCorner, shape.getLowerBound(), shape.getUpperBound(), pos -> {
            double noise = shape.noiseDiff((BlockPos)pos);
            if (noise > 0.0) {
                context.consume((BlockPos)pos, noise);
            }
        });
        if (context instanceof IFinishableContext) {
            ((IFinishableContext)context).finish();
        }
    }

    public abstract IGenerationContext createContext(BlockPos var1, ChunkGenerator var2, Random var3, BlockPos var4, WorldGenRegion var5);

    public static interface IFinishableContext
    extends IGenerationContext {
        public void finish();
    }

    public static interface IGenerationContext {
        public void consume(BlockPos var1, double var2);
    }
}

